/* soapServer.c
   Generated by gSOAP 2.7.17 from soapIf_sngtc.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif
#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapServer.c ver 2.7.17 2010-08-23 21:49:21 GMT")


SOAP_FMAC5 int SOAP_FMAC6 soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
		soap_destroy(soap);
		soap_end(soap);
	} while (1);
#else
		soap_destroy(soap);
		soap_end(soap);      
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:sngtc-create-transcoding-session"))
		return soap_serve_ns1__sngtc_create_transcoding_session(soap);
	if (!soap_match_tag(soap, soap->tag, "ns1:sngtc-free-transcoding-session"))
		return soap_serve_ns1__sngtc_free_transcoding_session(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__sngtc_create_transcoding_session(struct soap *soap)
{	struct ns1__sngtc_create_transcoding_session soap_tmp_ns1__sngtc_create_transcoding_session;
	struct ns1__sngtc_codec_reply codec_reply;
	soap_default_ns1__sngtc_codec_reply(soap, &codec_reply);
	soap_default_ns1__sngtc_create_transcoding_session(soap, &soap_tmp_ns1__sngtc_create_transcoding_session);
	soap->encodingStyle = NULL;
	if (!soap_get_ns1__sngtc_create_transcoding_session(soap, &soap_tmp_ns1__sngtc_create_transcoding_session, "ns1:sngtc-create-transcoding-session", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__sngtc_create_transcoding_session(soap, soap_tmp_ns1__sngtc_create_transcoding_session.codec_req, &codec_reply);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__sngtc_codec_reply(soap, &codec_reply);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__sngtc_codec_reply(soap, &codec_reply, "ns1:sngtc-codec-reply", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__sngtc_codec_reply(soap, &codec_reply, "ns1:sngtc-codec-reply", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_ns1__sngtc_free_transcoding_session(struct soap *soap)
{	struct ns1__sngtc_free_transcoding_session soap_tmp_ns1__sngtc_free_transcoding_session;
	struct ns1__sngtc_free_transcoding_sessionResponse soap_tmp_ns1__sngtc_free_transcoding_sessionResponse;
	int soap_tmp_int;
	soap_default_ns1__sngtc_free_transcoding_sessionResponse(soap, &soap_tmp_ns1__sngtc_free_transcoding_sessionResponse);
	soap_default_int(soap, &soap_tmp_int);
	soap_tmp_ns1__sngtc_free_transcoding_sessionResponse.result = &soap_tmp_int;
	soap_default_ns1__sngtc_free_transcoding_session(soap, &soap_tmp_ns1__sngtc_free_transcoding_session);
	soap->encodingStyle = NULL;
	if (!soap_get_ns1__sngtc_free_transcoding_session(soap, &soap_tmp_ns1__sngtc_free_transcoding_session, "ns1:sngtc-free-transcoding-session", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = ns1__sngtc_free_transcoding_session(soap, soap_tmp_ns1__sngtc_free_transcoding_session.codec_reply, &soap_tmp_int);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_ns1__sngtc_free_transcoding_sessionResponse(soap, &soap_tmp_ns1__sngtc_free_transcoding_sessionResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_ns1__sngtc_free_transcoding_sessionResponse(soap, &soap_tmp_ns1__sngtc_free_transcoding_sessionResponse, "ns1:sngtc-free-transcoding-sessionResponse", NULL)
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_ns1__sngtc_free_transcoding_sessionResponse(soap, &soap_tmp_ns1__sngtc_free_transcoding_sessionResponse, "ns1:sngtc-free-transcoding-sessionResponse", NULL)
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapServer.c */
