/*******************************************************************************//**
 * \file sangoma_transcode.h
 * \brief Sangoma Transcoding library for Vocallo/Sangoma Transcoding Board
 * \brief Provides User a Unified/OS Agnostic API to Sangoma Transcoding Board
 *
 * Author(s):   Nenad Corbic <ncorbic@sangoma.com>
 *
 * Copyright:	(c) 2009-2009 Nenad Corbic <ncorbic@sangoma.com>
*/


struct ns1__sngtc_codec_request_leg
{
	uint32_t 	codec_id;
	uint32_t	ms;

	uint32_t	host_ip;
	uint32_t	host_netmask;
	uint32_t	host_udp_port;

};


struct ns1__sngtc_codec_reply_leg
{
	uint32_t	codec_ip;
	uint32_t	codec_netmask;
	uint32_t	codec_udp_port;

	uint32_t	host_ip;
	uint32_t	host_netmask;
	uint32_t	host_udp_port;

	uint32_t	iana_code;

};


struct ns1__sngtc_codec_reply
{
	uint32_t 	codec_module_session_idx;
	uint32_t	codec_rtp_session_idx;

	struct ns1__sngtc_codec_reply_leg a;
	struct ns1__sngtc_codec_reply_leg b;

	void		*tx_fd;
	uint32_t	tx_iana;

	void		*rx_fd;
	uint32_t	rx_iana;

	int32_t		result;
};
 

struct ns1__sngtc_codec_request
{
	void *usr_priv;
	uint64_t 	tag;

	uint8_t		rtcp_enable;

	struct ns1__sngtc_codec_request_leg a;
	struct ns1__sngtc_codec_request_leg b;

};

int ns1__sngtc_create_transcoding_session (struct ns1__sngtc_codec_request *codec_req, 
										   struct ns1__sngtc_codec_reply *codec_reply);
int ns1__sngtc_free_transcoding_session   (struct ns1__sngtc_codec_reply *codec_reply, int *result); 
