/* soapC.c
   Generated by gSOAP 2.7.17 from soapIf_sngtc.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.17 2010-08-23 21:49:21 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_ns1__sngtc_free_transcoding_session:
		return soap_in_ns1__sngtc_free_transcoding_session(soap, NULL, NULL, "ns1:sngtc-free-transcoding-session");
	case SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse:
		return soap_in_ns1__sngtc_free_transcoding_sessionResponse(soap, NULL, NULL, "ns1:sngtc-free-transcoding-sessionResponse");
	case SOAP_TYPE_ns1__sngtc_create_transcoding_session:
		return soap_in_ns1__sngtc_create_transcoding_session(soap, NULL, NULL, "ns1:sngtc-create-transcoding-session");
	case SOAP_TYPE_ns1__sngtc_codec_request:
		return soap_in_ns1__sngtc_codec_request(soap, NULL, NULL, "ns1:sngtc-codec-request");
	case SOAP_TYPE_ns1__sngtc_codec_reply:
		return soap_in_ns1__sngtc_codec_reply(soap, NULL, NULL, "ns1:sngtc-codec-reply");
	case SOAP_TYPE_ns1__sngtc_codec_reply_leg:
		return soap_in_ns1__sngtc_codec_reply_leg(soap, NULL, NULL, "ns1:sngtc-codec-reply-leg");
	case SOAP_TYPE_ns1__sngtc_codec_request_leg:
		return soap_in_ns1__sngtc_codec_request_leg(soap, NULL, NULL, "ns1:sngtc-codec-request-leg");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTons1__sngtc_codec_reply:
		return soap_in_PointerTons1__sngtc_codec_reply(soap, NULL, NULL, "ns1:sngtc-codec-reply");
	case SOAP_TYPE_PointerTons1__sngtc_codec_request:
		return soap_in_PointerTons1__sngtc_codec_request(soap, NULL, NULL, "ns1:sngtc-codec-request");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-free-transcoding-session"))
		{	*type = SOAP_TYPE_ns1__sngtc_free_transcoding_session;
			return soap_in_ns1__sngtc_free_transcoding_session(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-free-transcoding-sessionResponse"))
		{	*type = SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse;
			return soap_in_ns1__sngtc_free_transcoding_sessionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-create-transcoding-session"))
		{	*type = SOAP_TYPE_ns1__sngtc_create_transcoding_session;
			return soap_in_ns1__sngtc_create_transcoding_session(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-codec-request"))
		{	*type = SOAP_TYPE_ns1__sngtc_codec_request;
			return soap_in_ns1__sngtc_codec_request(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-codec-reply"))
		{	*type = SOAP_TYPE_ns1__sngtc_codec_reply;
			return soap_in_ns1__sngtc_codec_reply(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-codec-reply-leg"))
		{	*type = SOAP_TYPE_ns1__sngtc_codec_reply_leg;
			return soap_in_ns1__sngtc_codec_reply_leg(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:sngtc-codec-request-leg"))
		{	*type = SOAP_TYPE_ns1__sngtc_codec_request_leg;
			return soap_in_ns1__sngtc_codec_request_leg(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_ns1__sngtc_free_transcoding_session:
		return soap_out_ns1__sngtc_free_transcoding_session(soap, tag, id, (const struct ns1__sngtc_free_transcoding_session *)ptr, "ns1:sngtc-free-transcoding-session");
	case SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse:
		return soap_out_ns1__sngtc_free_transcoding_sessionResponse(soap, tag, id, (const struct ns1__sngtc_free_transcoding_sessionResponse *)ptr, "ns1:sngtc-free-transcoding-sessionResponse");
	case SOAP_TYPE_ns1__sngtc_create_transcoding_session:
		return soap_out_ns1__sngtc_create_transcoding_session(soap, tag, id, (const struct ns1__sngtc_create_transcoding_session *)ptr, "ns1:sngtc-create-transcoding-session");
	case SOAP_TYPE_ns1__sngtc_codec_request:
		return soap_out_ns1__sngtc_codec_request(soap, tag, id, (const struct ns1__sngtc_codec_request *)ptr, "ns1:sngtc-codec-request");
	case SOAP_TYPE_ns1__sngtc_codec_reply:
		return soap_out_ns1__sngtc_codec_reply(soap, tag, id, (const struct ns1__sngtc_codec_reply *)ptr, "ns1:sngtc-codec-reply");
	case SOAP_TYPE_ns1__sngtc_codec_reply_leg:
		return soap_out_ns1__sngtc_codec_reply_leg(soap, tag, id, (const struct ns1__sngtc_codec_reply_leg *)ptr, "ns1:sngtc-codec-reply-leg");
	case SOAP_TYPE_ns1__sngtc_codec_request_leg:
		return soap_out_ns1__sngtc_codec_request_leg(soap, tag, id, (const struct ns1__sngtc_codec_request_leg *)ptr, "ns1:sngtc-codec-request-leg");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTons1__sngtc_codec_reply:
		return soap_out_PointerTons1__sngtc_codec_reply(soap, tag, id, (struct ns1__sngtc_codec_reply *const*)ptr, "ns1:sngtc-codec-reply");
	case SOAP_TYPE_PointerTons1__sngtc_codec_request:
		return soap_out_PointerTons1__sngtc_codec_request(soap, tag, id, (struct ns1__sngtc_codec_request *const*)ptr, "ns1:sngtc-codec-request");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns1__sngtc_free_transcoding_session:
		soap_serialize_ns1__sngtc_free_transcoding_session(soap, (const struct ns1__sngtc_free_transcoding_session *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse:
		soap_serialize_ns1__sngtc_free_transcoding_sessionResponse(soap, (const struct ns1__sngtc_free_transcoding_sessionResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_create_transcoding_session:
		soap_serialize_ns1__sngtc_create_transcoding_session(soap, (const struct ns1__sngtc_create_transcoding_session *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_codec_request:
		soap_serialize_ns1__sngtc_codec_request(soap, (const struct ns1__sngtc_codec_request *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_codec_reply:
		soap_serialize_ns1__sngtc_codec_reply(soap, (const struct ns1__sngtc_codec_reply *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_codec_reply_leg:
		soap_serialize_ns1__sngtc_codec_reply_leg(soap, (const struct ns1__sngtc_codec_reply_leg *)ptr);
		break;
	case SOAP_TYPE_ns1__sngtc_codec_request_leg:
		soap_serialize_ns1__sngtc_codec_request_leg(soap, (const struct ns1__sngtc_codec_request_leg *)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__sngtc_codec_reply:
		soap_serialize_PointerTons1__sngtc_codec_reply(soap, (struct ns1__sngtc_codec_reply *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__sngtc_codec_request:
		soap_serialize_PointerTons1__sngtc_codec_request(soap, (struct ns1__sngtc_codec_request *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{	unsigned char *p;
	p = soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{	unsigned int *p;
	p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{	ULONG64 *p;
	p = soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_free_transcoding_session(struct soap *soap, struct ns1__sngtc_free_transcoding_session *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->codec_reply = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_free_transcoding_session(struct soap *soap, const struct ns1__sngtc_free_transcoding_session *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__sngtc_codec_reply(soap, &a->codec_reply);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_free_transcoding_session(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_free_transcoding_session *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_free_transcoding_session), type))
		return soap->error;
	if (soap_out_PointerTons1__sngtc_codec_reply(soap, "codec-reply", -1, &a->codec_reply, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_free_transcoding_session * SOAP_FMAC4 soap_in_ns1__sngtc_free_transcoding_session(struct soap *soap, const char *tag, struct ns1__sngtc_free_transcoding_session *a, const char *type)
{
	size_t soap_flag_codec_reply = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_free_transcoding_session *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_free_transcoding_session, sizeof(struct ns1__sngtc_free_transcoding_session), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_free_transcoding_session(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_codec_reply && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__sngtc_codec_reply(soap, "codec-reply", &a->codec_reply, "ns1:sngtc-codec-reply"))
				{	soap_flag_codec_reply--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_free_transcoding_session *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_free_transcoding_session, 0, sizeof(struct ns1__sngtc_free_transcoding_session), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_free_transcoding_session(struct soap *soap, const struct ns1__sngtc_free_transcoding_session *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_free_transcoding_session);
	if (soap_out_ns1__sngtc_free_transcoding_session(soap, tag?tag:"ns1:sngtc-free-transcoding-session", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_free_transcoding_session * SOAP_FMAC4 soap_get_ns1__sngtc_free_transcoding_session(struct soap *soap, struct ns1__sngtc_free_transcoding_session *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_free_transcoding_session(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, struct ns1__sngtc_free_transcoding_sessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->result = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, const struct ns1__sngtc_free_transcoding_sessionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->result);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_free_transcoding_sessionResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_free_transcoding_sessionResponse * SOAP_FMAC4 soap_in_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, const char *tag, struct ns1__sngtc_free_transcoding_sessionResponse *a, const char *type)
{
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_free_transcoding_sessionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse, sizeof(struct ns1__sngtc_free_transcoding_sessionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_free_transcoding_sessionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "result", &a->result, "xsd:int"))
				{	soap_flag_result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_free_transcoding_sessionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse, 0, sizeof(struct ns1__sngtc_free_transcoding_sessionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, const struct ns1__sngtc_free_transcoding_sessionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_free_transcoding_sessionResponse);
	if (soap_out_ns1__sngtc_free_transcoding_sessionResponse(soap, tag?tag:"ns1:sngtc-free-transcoding-sessionResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_free_transcoding_sessionResponse * SOAP_FMAC4 soap_get_ns1__sngtc_free_transcoding_sessionResponse(struct soap *soap, struct ns1__sngtc_free_transcoding_sessionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_free_transcoding_sessionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_create_transcoding_session(struct soap *soap, struct ns1__sngtc_create_transcoding_session *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->codec_req = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_create_transcoding_session(struct soap *soap, const struct ns1__sngtc_create_transcoding_session *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__sngtc_codec_request(soap, &a->codec_req);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_create_transcoding_session(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_create_transcoding_session *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_create_transcoding_session), type))
		return soap->error;
	if (soap_out_PointerTons1__sngtc_codec_request(soap, "codec-req", -1, &a->codec_req, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_create_transcoding_session * SOAP_FMAC4 soap_in_ns1__sngtc_create_transcoding_session(struct soap *soap, const char *tag, struct ns1__sngtc_create_transcoding_session *a, const char *type)
{
	size_t soap_flag_codec_req = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_create_transcoding_session *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_create_transcoding_session, sizeof(struct ns1__sngtc_create_transcoding_session), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_create_transcoding_session(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_codec_req && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__sngtc_codec_request(soap, "codec-req", &a->codec_req, "ns1:sngtc-codec-request"))
				{	soap_flag_codec_req--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_create_transcoding_session *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_create_transcoding_session, 0, sizeof(struct ns1__sngtc_create_transcoding_session), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_create_transcoding_session(struct soap *soap, const struct ns1__sngtc_create_transcoding_session *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_create_transcoding_session);
	if (soap_out_ns1__sngtc_create_transcoding_session(soap, tag?tag:"ns1:sngtc-create-transcoding-session", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_create_transcoding_session * SOAP_FMAC4 soap_get_ns1__sngtc_create_transcoding_session(struct soap *soap, struct ns1__sngtc_create_transcoding_session *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_create_transcoding_session(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_codec_request(struct soap *soap, struct ns1__sngtc_codec_request *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient usr_priv skipped */
	soap_default_unsignedLONG64(soap, &a->tag);
	soap_default_unsignedByte(soap, &a->rtcp_enable);
	soap_default_ns1__sngtc_codec_request_leg(soap, &a->a);
	soap_default_ns1__sngtc_codec_request_leg(soap, &a->b);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_codec_request(struct soap *soap, const struct ns1__sngtc_codec_request *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient usr_priv skipped */
	soap_serialize_ns1__sngtc_codec_request_leg(soap, &a->a);
	soap_serialize_ns1__sngtc_codec_request_leg(soap, &a->b);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_codec_request(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_codec_request *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_codec_request), type))
		return soap->error;
	/* transient usr_priv skipped */
	if (soap_out_unsignedLONG64(soap, "tag", -1, &a->tag, ""))
		return soap->error;
	if (soap_out_unsignedByte(soap, "rtcp-enable", -1, &a->rtcp_enable, ""))
		return soap->error;
	if (soap_out_ns1__sngtc_codec_request_leg(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_ns1__sngtc_codec_request_leg(soap, "b", -1, &a->b, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request * SOAP_FMAC4 soap_in_ns1__sngtc_codec_request(struct soap *soap, const char *tag, struct ns1__sngtc_codec_request *a, const char *type)
{
	size_t soap_flag_tag = 1;
	size_t soap_flag_rtcp_enable = 1;
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_codec_request *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_codec_request, sizeof(struct ns1__sngtc_codec_request), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_codec_request(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient usr_priv skipped */
			if (soap_flag_tag && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedLONG64(soap, "tag", &a->tag, "xsd:unsignedLong"))
				{	soap_flag_tag--;
					continue;
				}
			if (soap_flag_rtcp_enable && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedByte(soap, "rtcp-enable", &a->rtcp_enable, "xsd:unsignedByte"))
				{	soap_flag_rtcp_enable--;
					continue;
				}
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ns1__sngtc_codec_request_leg(soap, "a", &a->a, "ns1:sngtc-codec-request-leg"))
				{	soap_flag_a--;
					continue;
				}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ns1__sngtc_codec_request_leg(soap, "b", &a->b, "ns1:sngtc-codec-request-leg"))
				{	soap_flag_b--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_request *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_codec_request, 0, sizeof(struct ns1__sngtc_codec_request), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_tag > 0 || soap_flag_rtcp_enable > 0 || soap_flag_a > 0 || soap_flag_b > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_codec_request(struct soap *soap, const struct ns1__sngtc_codec_request *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_codec_request);
	if (soap_out_ns1__sngtc_codec_request(soap, tag?tag:"ns1:sngtc-codec-request", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request * SOAP_FMAC4 soap_get_ns1__sngtc_codec_request(struct soap *soap, struct ns1__sngtc_codec_request *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_codec_request(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_codec_reply(struct soap *soap, struct ns1__sngtc_codec_reply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->codec_module_session_idx);
	soap_default_unsignedInt(soap, &a->codec_rtp_session_idx);
	soap_default_ns1__sngtc_codec_reply_leg(soap, &a->a);
	soap_default_ns1__sngtc_codec_reply_leg(soap, &a->b);
	/* transient tx_fd skipped */
	soap_default_unsignedInt(soap, &a->tx_iana);
	/* transient rx_fd skipped */
	soap_default_unsignedInt(soap, &a->rx_iana);
	soap_default_int(soap, &a->result);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_codec_reply(struct soap *soap, const struct ns1__sngtc_codec_reply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ns1__sngtc_codec_reply_leg(soap, &a->a);
	soap_serialize_ns1__sngtc_codec_reply_leg(soap, &a->b);
	/* transient tx_fd skipped */
	/* transient rx_fd skipped */
	soap_embedded(soap, &a->result, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_codec_reply(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_codec_reply *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_codec_reply), type))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-module-session-idx", -1, &a->codec_module_session_idx, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-rtp-session-idx", -1, &a->codec_rtp_session_idx, ""))
		return soap->error;
	if (soap_out_ns1__sngtc_codec_reply_leg(soap, "a", -1, &a->a, ""))
		return soap->error;
	if (soap_out_ns1__sngtc_codec_reply_leg(soap, "b", -1, &a->b, ""))
		return soap->error;
	/* transient tx_fd skipped */
	if (soap_out_unsignedInt(soap, "tx-iana", -1, &a->tx_iana, ""))
		return soap->error;
	/* transient rx_fd skipped */
	if (soap_out_unsignedInt(soap, "rx-iana", -1, &a->rx_iana, ""))
		return soap->error;
	if (soap_out_int(soap, "result", -1, &a->result, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply * SOAP_FMAC4 soap_in_ns1__sngtc_codec_reply(struct soap *soap, const char *tag, struct ns1__sngtc_codec_reply *a, const char *type)
{
	size_t soap_flag_codec_module_session_idx = 1;
	size_t soap_flag_codec_rtp_session_idx = 1;
	size_t soap_flag_a = 1;
	size_t soap_flag_b = 1;
	size_t soap_flag_tx_iana = 1;
	size_t soap_flag_rx_iana = 1;
	size_t soap_flag_result = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_codec_reply *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_codec_reply, sizeof(struct ns1__sngtc_codec_reply), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_codec_reply(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_codec_module_session_idx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-module-session-idx", &a->codec_module_session_idx, "xsd:unsignedInt"))
				{	soap_flag_codec_module_session_idx--;
					continue;
				}
			if (soap_flag_codec_rtp_session_idx && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-rtp-session-idx", &a->codec_rtp_session_idx, "xsd:unsignedInt"))
				{	soap_flag_codec_rtp_session_idx--;
					continue;
				}
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ns1__sngtc_codec_reply_leg(soap, "a", &a->a, "ns1:sngtc-codec-reply-leg"))
				{	soap_flag_a--;
					continue;
				}
			if (soap_flag_b && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ns1__sngtc_codec_reply_leg(soap, "b", &a->b, "ns1:sngtc-codec-reply-leg"))
				{	soap_flag_b--;
					continue;
				}
		/* transient tx_fd skipped */
			if (soap_flag_tx_iana && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "tx-iana", &a->tx_iana, "xsd:unsignedInt"))
				{	soap_flag_tx_iana--;
					continue;
				}
		/* transient rx_fd skipped */
			if (soap_flag_rx_iana && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "rx-iana", &a->rx_iana, "xsd:unsignedInt"))
				{	soap_flag_rx_iana--;
					continue;
				}
			if (soap_flag_result && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "result", &a->result, "xsd:int"))
				{	soap_flag_result--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_reply *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_codec_reply, 0, sizeof(struct ns1__sngtc_codec_reply), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_codec_module_session_idx > 0 || soap_flag_codec_rtp_session_idx > 0 || soap_flag_a > 0 || soap_flag_b > 0 || soap_flag_tx_iana > 0 || soap_flag_rx_iana > 0 || soap_flag_result > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_codec_reply(struct soap *soap, const struct ns1__sngtc_codec_reply *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_codec_reply);
	if (soap_out_ns1__sngtc_codec_reply(soap, tag?tag:"ns1:sngtc-codec-reply", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply * SOAP_FMAC4 soap_get_ns1__sngtc_codec_reply(struct soap *soap, struct ns1__sngtc_codec_reply *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_codec_reply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_codec_reply_leg(struct soap *soap, struct ns1__sngtc_codec_reply_leg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->codec_ip);
	soap_default_unsignedInt(soap, &a->codec_netmask);
	soap_default_unsignedInt(soap, &a->codec_udp_port);
	soap_default_unsignedInt(soap, &a->host_ip);
	soap_default_unsignedInt(soap, &a->host_netmask);
	soap_default_unsignedInt(soap, &a->host_udp_port);
	soap_default_unsignedInt(soap, &a->iana_code);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_codec_reply_leg(struct soap *soap, const struct ns1__sngtc_codec_reply_leg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_codec_reply_leg(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_codec_reply_leg *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_codec_reply_leg), type))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-ip", -1, &a->codec_ip, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-netmask", -1, &a->codec_netmask, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-udp-port", -1, &a->codec_udp_port, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-ip", -1, &a->host_ip, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-netmask", -1, &a->host_netmask, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-udp-port", -1, &a->host_udp_port, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "iana-code", -1, &a->iana_code, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply_leg * SOAP_FMAC4 soap_in_ns1__sngtc_codec_reply_leg(struct soap *soap, const char *tag, struct ns1__sngtc_codec_reply_leg *a, const char *type)
{
	size_t soap_flag_codec_ip = 1;
	size_t soap_flag_codec_netmask = 1;
	size_t soap_flag_codec_udp_port = 1;
	size_t soap_flag_host_ip = 1;
	size_t soap_flag_host_netmask = 1;
	size_t soap_flag_host_udp_port = 1;
	size_t soap_flag_iana_code = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_codec_reply_leg *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_codec_reply_leg, sizeof(struct ns1__sngtc_codec_reply_leg), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_codec_reply_leg(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_codec_ip && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-ip", &a->codec_ip, "xsd:unsignedInt"))
				{	soap_flag_codec_ip--;
					continue;
				}
			if (soap_flag_codec_netmask && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-netmask", &a->codec_netmask, "xsd:unsignedInt"))
				{	soap_flag_codec_netmask--;
					continue;
				}
			if (soap_flag_codec_udp_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-udp-port", &a->codec_udp_port, "xsd:unsignedInt"))
				{	soap_flag_codec_udp_port--;
					continue;
				}
			if (soap_flag_host_ip && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-ip", &a->host_ip, "xsd:unsignedInt"))
				{	soap_flag_host_ip--;
					continue;
				}
			if (soap_flag_host_netmask && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-netmask", &a->host_netmask, "xsd:unsignedInt"))
				{	soap_flag_host_netmask--;
					continue;
				}
			if (soap_flag_host_udp_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-udp-port", &a->host_udp_port, "xsd:unsignedInt"))
				{	soap_flag_host_udp_port--;
					continue;
				}
			if (soap_flag_iana_code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "iana-code", &a->iana_code, "xsd:unsignedInt"))
				{	soap_flag_iana_code--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_reply_leg *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_codec_reply_leg, 0, sizeof(struct ns1__sngtc_codec_reply_leg), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_codec_ip > 0 || soap_flag_codec_netmask > 0 || soap_flag_codec_udp_port > 0 || soap_flag_host_ip > 0 || soap_flag_host_netmask > 0 || soap_flag_host_udp_port > 0 || soap_flag_iana_code > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_codec_reply_leg(struct soap *soap, const struct ns1__sngtc_codec_reply_leg *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_codec_reply_leg);
	if (soap_out_ns1__sngtc_codec_reply_leg(soap, tag?tag:"ns1:sngtc-codec-reply-leg", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply_leg * SOAP_FMAC4 soap_get_ns1__sngtc_codec_reply_leg(struct soap *soap, struct ns1__sngtc_codec_reply_leg *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_codec_reply_leg(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__sngtc_codec_request_leg(struct soap *soap, struct ns1__sngtc_codec_request_leg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->codec_id);
	soap_default_unsignedInt(soap, &a->ms);
	soap_default_unsignedInt(soap, &a->host_ip);
	soap_default_unsignedInt(soap, &a->host_netmask);
	soap_default_unsignedInt(soap, &a->host_udp_port);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__sngtc_codec_request_leg(struct soap *soap, const struct ns1__sngtc_codec_request_leg *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__sngtc_codec_request_leg(struct soap *soap, const char *tag, int id, const struct ns1__sngtc_codec_request_leg *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__sngtc_codec_request_leg), type))
		return soap->error;
	if (soap_out_unsignedInt(soap, "codec-id", -1, &a->codec_id, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "ms", -1, &a->ms, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-ip", -1, &a->host_ip, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-netmask", -1, &a->host_netmask, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "host-udp-port", -1, &a->host_udp_port, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request_leg * SOAP_FMAC4 soap_in_ns1__sngtc_codec_request_leg(struct soap *soap, const char *tag, struct ns1__sngtc_codec_request_leg *a, const char *type)
{
	size_t soap_flag_codec_id = 1;
	size_t soap_flag_ms = 1;
	size_t soap_flag_host_ip = 1;
	size_t soap_flag_host_netmask = 1;
	size_t soap_flag_host_udp_port = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__sngtc_codec_request_leg *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__sngtc_codec_request_leg, sizeof(struct ns1__sngtc_codec_request_leg), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__sngtc_codec_request_leg(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_codec_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "codec-id", &a->codec_id, "xsd:unsignedInt"))
				{	soap_flag_codec_id--;
					continue;
				}
			if (soap_flag_ms && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "ms", &a->ms, "xsd:unsignedInt"))
				{	soap_flag_ms--;
					continue;
				}
			if (soap_flag_host_ip && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-ip", &a->host_ip, "xsd:unsignedInt"))
				{	soap_flag_host_ip--;
					continue;
				}
			if (soap_flag_host_netmask && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-netmask", &a->host_netmask, "xsd:unsignedInt"))
				{	soap_flag_host_netmask--;
					continue;
				}
			if (soap_flag_host_udp_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "host-udp-port", &a->host_udp_port, "xsd:unsignedInt"))
				{	soap_flag_host_udp_port--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_request_leg *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__sngtc_codec_request_leg, 0, sizeof(struct ns1__sngtc_codec_request_leg), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_codec_id > 0 || soap_flag_ms > 0 || soap_flag_host_ip > 0 || soap_flag_host_netmask > 0 || soap_flag_host_udp_port > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__sngtc_codec_request_leg(struct soap *soap, const struct ns1__sngtc_codec_request_leg *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__sngtc_codec_request_leg);
	if (soap_out_ns1__sngtc_codec_request_leg(soap, tag?tag:"ns1:sngtc-codec-request-leg", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request_leg * SOAP_FMAC4 soap_get_ns1__sngtc_codec_request_leg(struct soap *soap, struct ns1__sngtc_codec_request_leg *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__sngtc_codec_request_leg(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__sngtc_codec_reply(struct soap *soap, struct ns1__sngtc_codec_reply *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__sngtc_codec_reply))
		soap_serialize_ns1__sngtc_codec_reply(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__sngtc_codec_reply(struct soap *soap, const char *tag, int id, struct ns1__sngtc_codec_reply *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__sngtc_codec_reply);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__sngtc_codec_reply(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply ** SOAP_FMAC4 soap_in_PointerTons1__sngtc_codec_reply(struct soap *soap, const char *tag, struct ns1__sngtc_codec_reply **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__sngtc_codec_reply **)soap_malloc(soap, sizeof(struct ns1__sngtc_codec_reply *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__sngtc_codec_reply(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_reply **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__sngtc_codec_reply, sizeof(struct ns1__sngtc_codec_reply), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__sngtc_codec_reply(struct soap *soap, struct ns1__sngtc_codec_reply *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__sngtc_codec_reply);
	if (soap_out_PointerTons1__sngtc_codec_reply(soap, tag?tag:"ns1:sngtc-codec-reply", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_reply ** SOAP_FMAC4 soap_get_PointerTons1__sngtc_codec_reply(struct soap *soap, struct ns1__sngtc_codec_reply **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__sngtc_codec_reply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__sngtc_codec_request(struct soap *soap, struct ns1__sngtc_codec_request *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__sngtc_codec_request))
		soap_serialize_ns1__sngtc_codec_request(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__sngtc_codec_request(struct soap *soap, const char *tag, int id, struct ns1__sngtc_codec_request *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__sngtc_codec_request);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__sngtc_codec_request(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request ** SOAP_FMAC4 soap_in_PointerTons1__sngtc_codec_request(struct soap *soap, const char *tag, struct ns1__sngtc_codec_request **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__sngtc_codec_request **)soap_malloc(soap, sizeof(struct ns1__sngtc_codec_request *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__sngtc_codec_request(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__sngtc_codec_request **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__sngtc_codec_request, sizeof(struct ns1__sngtc_codec_request), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__sngtc_codec_request(struct soap *soap, struct ns1__sngtc_codec_request *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__sngtc_codec_request);
	if (soap_out_PointerTons1__sngtc_codec_request(soap, tag?tag:"ns1:sngtc-codec-request", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns1__sngtc_codec_request ** SOAP_FMAC4 soap_get_PointerTons1__sngtc_codec_request(struct soap *soap, struct ns1__sngtc_codec_request **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__sngtc_codec_request(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.c */
