#!/bin/sh

res=1

eval "soapcpp2 -c soapIf_sngtc.h"

if [ $? -eq 0 ]; then
  	echo "Patching soapServer.c"
	echo "patch -p0 < soapServer_destroy.patch"
	eval "patch -p0 < soapServer_destroy.patch"
	if [ $? -eq 0 ]; then
		echo
      	echo "Soap Server destroy patch successfull!"
		echo "All OK"
		echo
		res=0
	else
		echo
      	echo "Soap Server destroy patch failed!"
		echo
        exit 1
	fi
else
	exit 1
fi

echo
echo "IMPORTANT"
echo "================================================================" 
echo "Note the soapServer.c was patched using soapServer_destroy.patch"
echo "The server code is running in FastCGI like mode but we are not" 
echo "running it as part of web server. Thus we had to make our change"
echo "so that each finished request is deallocated before new request"
echo "is taken. Otherwise we would leak until segfault :) "
echo "================================================================" 
echo
