/*
 * Sangoma Transcoder SOAP Server
 *
 * Copyright (C) 2010, Sangoma Technologies 
 *
 * Nenad Corbic <ncorbic@sangoma.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *
 * Moises Silva <moy@sangoma.com>
 *
 */
#ifndef __SNGTC_SERVER_H__
#define __SNGTC_SERVER_H__

// common configuration options & declarations (always include first)
#include "config.h"

// C language includes
#include <stdio.h>
#include <stdlib.h> // atoi, exit
#include <string.h>


#if PLATFORM(Windows)
#define snprintf _snprintf
#else
#include <signal.h>
#endif

// application includes
#include "Server.h" /* server_xxx functions */

#include "sng_tc/sng_tc.h"

#define SERVER_IP_SIZE 50
extern sngtc_init_cfg_t g_init;
extern char sngtc_server_ip_str[SERVER_IP_SIZE];
extern int sngtc_server_port;
extern int sngtc_cpu_high;
extern int sngtc_cpu_low;

int sngtc_parse_xml_config_file(char *file);
int log_printf(int level, char* fmt, ...);

#if 0
#define SNGTC_PRINT(level,a,...) log_printf(level,a,##__VA_ARGS__)
#define SNGTC_DEBUG(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_DEBUG,a,##__VA_ARGS__)
#define SNGTC_WARN(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_WARN,a,##__VA_ARGS__)
#define SNGTC_INFO(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_L_INFO,a,##__VA_ARGS__)
#define SNGTC_STATS(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_STATS,a,##__VA_ARGS__)
#define SNGTC_ERROR(a,...)		SNGTC_PRINT(SNGTC_LOGLEVEL_ERROR,a,##__VA_ARGS__)
#define SNGTC_CRIT(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_CRIT,a,##__VA_ARGS__)
#define SNGTC_RES(a,...) 		SNGTC_PRINT(SNGTC_LOGLEVEL_L_RES,a,##__VA_ARGS__)
#define SNGTC_TEST(a,...)

#define SNGTC_L_LOGLEVEL_DECODE(level) \
		((level==SNGTC_LOGLEVEL_DEBUG) ? "SNGTC_DEBUG" : \
		(level==SNGTC_LOGLEVEL_WARN) ? "SNGTC_WARN" : \
		(level==SNGTC_LOGLEVEL_INFO) ? "SNGTC_INFO" : \
		(level==SNGTC_LOGLEVEL_L_INFO) ? "SNGTC_INFO" : \
		(level==SNGTC_LOGLEVEL_L_RES) ? "SNGTC_RESLT" : \
		(level==SNGTC_LOGLEVEL_STATS) ? "SNGTC_STATS" : \
		(level==SNGTC_LOGLEVEL_ERROR) ? "SNGTC_ERROR" : \
		(level==SNGTC_LOGLEVEL_CRIT) ? "SNGTC_CRIT" : "Unknown")        
#endif

#define TS2_LOGLEVEL_DECODE(level) \
		((level==LOG_LEVEL_FATAL) ? "LOG_LEVEL_FATAL" : \
		 (level==LOG_LEVEL_ERROR) ? "LOG_LEVEL_ERROR" : \
		 (level==LOG_LEVEL_WARN) ? "LOG_LEVEL_WARN" : \
		 (level==LOG_LEVEL_INFO) ? "LOG_LEVEL_INFO" : \
		 (level==LOG_LEVEL_DEBUG) ? "LOG_LEVEL_DEBUG" : \
		 (level==LOG_LEVEL_TRACE) ? "LOG_LEVEL_TRACE" :  "Unknown")

#endif

