/* ---------------------------------------------------------------------------
          Copyright (c) 2003-2008 Micrel, Inc.  All rights reserved.
   ---------------------------------------------------------------------------

    NdisDevice.h - NDIS driver device definitions.

    Author      Date        Description
    THa         12/01/03    Created file.
    THa         09/29/05    Changed descriptor structure.
    THa         02/23/06    Updated for WinCE 5.0.
    THa         04/13/06    Version 1.2.
    THa         07/27/06    Version 1.4 supports NDIS 5.
    THa         10/04/06    Version 1.6 delays reporting driver reset status.
    THa         12/21/06    Version 1.7 fixes MIB counter read problem.
    THa         12/18/07    Update for 64-bit systems.
    THa         01/22/08    Update for 64-bit Windows.
   ---------------------------------------------------------------------------
*/


#ifndef __NDIS_DEVICE_H
#define __NDIS_DEVICE_H

/* -------------------------------------------------------------------------- */

#ifdef DEF_KS8842
#define NDIS_NAME  "KSZ8842"
#else
#define NDIS_NAME  "KSZ8841"
#endif


#ifdef UNDER_CE

//
// Windows CE debug zones
//
#if DBG
#define ZONE_ERROR_BIT      0
#define ZONE_WARN_BIT       1
#define ZONE_FUNC_BIT       2
#define ZONE_INIT_BIT       3
#define ZONE_INTR_BIT       4
#define ZONE_RCV_BIT        5
#define ZONE_XMIT_BIT       6
#define ZONE_LINK_BIT       7

#define ZONE_ERROR_MASK     (1 << ZONE_ERROR_BIT)
#define ZONE_WARN_MASK      (1 << ZONE_WARN_BIT)
#define ZONE_FUNC_MASK      (1 << ZONE_FUNC_BIT)
#define ZONE_INIT_MASK      (1 << ZONE_INIT_BIT)
#define ZONE_INTR_MASK      (1 << ZONE_INTR_BIT)
#define ZONE_RCV_MASK       (1 << ZONE_RCV_BIT)
#define ZONE_XMIT_MASK      (1 << ZONE_XMIT_BIT)
#define ZONE_LINK_MASK      (1 << ZONE_LINK_BIT)

#define ZONE_ERROR          DEBUGZONE(ZONE_ERROR_BIT)
#define ZONE_WARN           DEBUGZONE(ZONE_WARN_BIT)
#define ZONE_FUNC           DEBUGZONE(ZONE_FUNC_BIT)
#define ZONE_INIT           DEBUGZONE(ZONE_INIT_BIT)
#define ZONE_INTR           DEBUGZONE(ZONE_INTR_BIT)
#define ZONE_RCV            DEBUGZONE(ZONE_RCV_BIT)
#define ZONE_XMIT           DEBUGZONE(ZONE_XMIT_BIT)
#define ZONE_LINK           DEBUGZONE(ZONE_LINK_BIT)
#endif
#endif

/* -------------------------------------------------------------------------- */

#if defined( NDIS51_MINIPORT )

#define NDISVER  51

#define NDIS_MAJOR_VERSION  5
#define NDIS_MINOR_VERSION  1

#elif defined( NDIS50_MINIPORT )

#define NDISVER  50

#define NDIS_MAJOR_VERSION  5
#define NDIS_MINOR_VERSION  0

#elif defined( NDIS40_MINIPORT )

#define NDISVER  40

#define NDIS_MAJOR_VERSION  4
#define NDIS_MINOR_VERSION  0

#else

#define NDISVER  30

#define NDIS_MAJOR_VERSION  3
#define NDIS_MINOR_VERSION  0

#endif

#define DRIVER_MAJOR_VERSION    1
#define DRIVER_MINOR_VERSION    7

/* -------------------------------------------------------------------------- */

BOOLEAN MiniportCheckForHang (
    IN  NDIS_HANDLE hAdapterContext );

VOID MiniportDisableInterrupt (
    IN  NDIS_HANDLE hAdapterContext );

VOID MiniportEnableInterrupt (
    IN  NDIS_HANDLE hAdapterContext );

VOID MiniportHandleInterrupt (
    IN  NDIS_HANDLE hAdapterContext );

VOID MiniportISR (
    OUT PBOOLEAN pbInterruptRecognized,
    OUT PBOOLEAN pbQueueDpc,
    IN  PVOID    pContext );

NDIS_STATUS MiniportReset (
    OUT PBOOLEAN    AddressingReset,
    IN  NDIS_HANDLE hAdapterContext );

NDIS_STATUS MiniportTransferData (
    OUT PNDIS_PACKET pPacket,
    OUT PUINT        puiBytesTransferred,
    IN  NDIS_HANDLE  hAdapterContext,
    IN  NDIS_HANDLE  hReceiveContext,
    IN  UINT         uiByteOffset,
    IN  UINT         uiBytesToTransfer );

VOID MiniportReturnPacket (
    IN  NDIS_HANDLE  hAdapterContext,
        PNDIS_PACKET Packet );

// NdisSend.cpp
NDIS_STATUS MiniportSend (
    IN  NDIS_HANDLE  hAdapterContext,
    IN  PNDIS_PACKET pPacket,
    IN  UINT         uiFlags );

VOID MiniportSendPackets (
    IN  NDIS_HANDLE   hAdapterContext,
    IN  PPNDIS_PACKET pPacketArray,
    IN  UINT          uiCount );

/* -------------------------------------------------------------------------- */

#include "hardware.h"

#if (NDISVER >= 50)
#include <pshpack1.h>

#else
#include <packon.h>
#endif

/* -------------------------------------------------------------------------- */

#define DRIVER_STATE_INIT          0x00000001
#define DRIVER_STATE_RESET         0x00000002


#define TASK_OFFLOAD_CHECKSUM      0x00000001
#define TASK_OFFLOAD_IP_CHECKSUM   0x00000002
#define TASK_OFFLOAD_TCP_CHECKSUM  0x00000004
#define TASK_OFFLOAD_UDP_CHECKSUM  0x00000008


#if (NDISVER >= 50)
// Data structure for Wake Up Packet Pattern
#define MAX_PATTERN_LENGTH          128
#define MAX_WAKE_UP_PACKET          4

typedef struct tWAKE_UP_PACKET
{
    NDIS_PM_PACKET_PATTERN NdisPacketPattern;
    UCHAR MaskAndPattern[ MAX_PATTERN_LENGTH + MAX_PATTERN_LENGTH / 8 ];
} WAKE_UP_PACKET, *PWAKE_UP_PACKET;
#endif


typedef enum {
    CARD_TYPE_PCMCIA,
    CARD_TYPE_PCI,
    CARD_TYPE_PCI_TYPE0
} ECardType;


#define RX_PACKET_ARRAY_SIZE  NUM_OF_RX_DESC

#define NDIS_BUFFER_SIZE   2000
#define MIN_MAP_REGISTERS  4
#define MAX_MAP_REGISTERS  NUM_OF_TX_DESC

typedef struct _MAP_REG
{
    UINT             uiRegister;
    PNDIS_BUFFER     pNdisBuffer;
    struct _MAP_REG* pNext;
} MAP_REG, *PMAP_REG;


typedef struct
{
    UINT                  ulAllocSize;
    UINT                  ulPhysical;
    BOOLEAN               bCached;
    PUCHAR                pAllocVirtual;
    PUCHAR                pVirtual;
    NDIS_PHYSICAL_ADDRESS AllocPhysicalAddr;
} SHARED_MEM, *PSHARED_MEM;


typedef struct _DMA_BUFFER
{
#ifndef UNDER_CE
    SLIST_ENTRY           listEntry;
#else
    struct _DMA_BUFFER*   pNext;
#endif
    SHARED_MEM            sm;
    UINT                  ulSize;
    NDIS_PHYSICAL_ADDRESS PhysicalAddr;
    PNDIS_BUFFER          pNdisBuffer;
    PNDIS_PACKET          pNdisPacket;
    PMAP_REG              pMapReg;
} DMA_BUFFER, *PDMA_BUFFER;

#define DMA_BUFFER( pDesc )  (( PDMA_BUFFER )(( pDesc )->pReserved ))


typedef struct
{
    PVOID        pDesc;
    PDMA_BUFFER  pDma;
    PNDIS_PACKET Next;
} PACKET_RESERVED, *PPACKET_RESERVED;

#define RESERVED( Packet )  (( PPACKET_RESERVED )(( Packet )->MiniportReserved ))


typedef struct
{
    NDIS_SPIN_LOCK listLock;

#ifndef UNDER_CE
    SLIST_HEADER   listHead;
#endif

    /* Memory pool for buffers. */
    SHARED_MEM  MemPool;

    /* Array of buffers. */
    PDMA_BUFFER BufArray;

    /* Current buffer being manipulated .*/
    PDMA_BUFFER pCurrent;

#ifdef UNDER_CE
    /* First buffer in the free stack. */
    PDMA_BUFFER pTop;

    /* Number of buffers available for use. */
    int         cnAvail;
#endif

    /* Number of buffers allocated. */
    int         cnAlloc;
} BUFFER_INFO, *PBUFFER_INFO;

/* -------------------------------------------------------------------------- */

typedef struct _NDIS_ADAPTER
{
    NDIS_HANDLE             m_hAdapter;

    NDIS_MINIPORT_INTERRUPT m_Interrupt;

    NDIS_INTERFACE_TYPE     m_BusType;

    NDIS_SPIN_LOCK          m_lockAdapter;
    NDIS_SPIN_LOCK          m_lockReceive;
    NDIS_SPIN_LOCK          m_lockHardware;

    NDIS_MINIPORT_TIMER     m_PeriodTimer;
    NDIS_MINIPORT_TIMER     m_ResetTimer;

    HARDWARE                m_Hardware;

    UINT                    m_ulPacketFilter;
    UINT                    m_ulPacketsNotAllowed;
    UINT                    m_ulMaxLookAhead;
    UINT                    m_ulNdisMediaState;

    // hardware resources
#ifdef _WIN64
    LONGLONG                m_ulMemoryAddress;
#else
    ULONG                   m_ulMemoryAddress;
#endif
    UINT                    m_ulMemorySize;
    UINT                    m_ulInterruptNumber;
    UINT                    m_ulInterruptVector;
    UINT                    m_ulIOBaseAddress;
    UINT                    m_ulIOLength;

#if (NDISVER >= 50)
    NDIS_PNP_CAPABILITIES   PNP_Capabilities;
    NDIS_DEVICE_POWER_STATE CurrentPowerState;
    NDIS_DEVICE_POWER_STATE NextPowerState;
    UINT                    m_ulWakeUpEnable;
    UINT                    m_ulWakeUpOk;
    UINT                    m_ulWakeUpError;
    WAKE_UP_PACKET          WakeUpPacket[ MAX_WAKE_UP_PACKET ];
    int                     m_cnWakeUpPacket;
#endif

    UINT                    m_ulTxChecksum;
    UINT                    m_ulRxChecksum;

    // member variables used for transmitting
    PNDIS_PACKET            m_pPacketQueueHead;
    PNDIS_PACKET            m_pPacketQueueTail;

    NDIS_HANDLE             m_hPacketPool;
    NDIS_HANDLE             m_hBufferPool;

    SHARED_MEM              m_DescPool;

    BUFFER_INFO             m_RxBufInfo;
    BUFFER_INFO             m_TxBufInfo;
    int                     m_nPME_wait;

    PMAP_REG                m_MapReg;
    PMAP_REG                m_pMapRegTop;
    int                     m_cnMapRegAlloc;
    int                     m_cnMapRegAvail;

    PNDIS_PACKET*           m_PacketArray;
    int                     m_cnPackets;

    UINT                    m_ulDriverState;
    UINT                    m_ulSlot;
    ECardType               m_CardType;

#ifdef UNDER_CE
    BOOL                    m_bPacketFilterSet;

#else
    BOOLEAN                 m_bPacketFilterSet;
#endif
} NDIS_ADAPTER;

typedef struct _NDIS_ADAPTER* PNDIS_ADAPTER;

#if (NDISVER >= 50)
#include <poppack.h>
#else

#ifdef UNDER_CE
    #pragma warning(disable:4103)
    #pragma pack(1)

#else
#include <packoff.h>
#endif
#endif

/* -------------------------------------------------------------------------- */

VOID DriverSleep (
    IN  PNDIS_ADAPTER pAdapter );

VOID DriverWake (
    IN  PNDIS_ADAPTER           pAdapter,
    IN  NDIS_DEVICE_POWER_STATE LastPowerState );

VOID FreeMemory (
        PNDIS_ADAPTER pAdapter );

NDIS_STATUS InitAdapter (
        PNDIS_ADAPTER pAdapter,
    IN  NDIS_HANDLE   hAdapter,
    IN  NDIS_HANDLE   hConfiguration );

NDIS_STATUS SetupAdapter (
        PNDIS_ADAPTER pAdapter );

void ShutdownAdapter (
    IN  PNDIS_ADAPTER pAdapter );

void StartAdapter (
    IN  PNDIS_ADAPTER pAdapter );

BOOLEAN AdapterReset (
        PNDIS_ADAPTER pAdapter );

VOID DeRegisterAdapter (
    PNDIS_ADAPTER pAdapter );

NDIS_STATUS RegisterAdapter (
    PNDIS_ADAPTER pAdapter );


BOOLEAN AcquireAdapter (
    IN  PNDIS_ADAPTER pAdapter,
    IN  BOOLEAN       fWait );

VOID ReleaseAdapter (
    IN  PNDIS_ADAPTER pAdapter );

VOID AdapterGetDescription (
    PVOID* ppSource,
    PUINT  puiLength );

ULONGLONG AdapterReadCounter (
    PNDIS_ADAPTER pAdapter,
    EOidCounter   OidCounter );

// in NdisSend.cpp
UINT AdapterTransmitQueueLength (
    IN  PNDIS_ADAPTER pAdapter );

#if 0
BOOLEAN AdapterCopyDownPacket (
    IN  PNDIS_ADAPTER pAdapter,
    IN  USHORT        wFID,
    IN  USHORT        wOffset,
    IN  PNDIS_PACKET  pPacket,
    OUT PUINT         puiLength,
    IN  UCHAR         bBAP );
#endif

BOOLEAN AdapterLockSend (
    IN  PNDIS_ADAPTER pAdapter );

void AdapterUnlockSend (
    IN  PNDIS_ADAPTER pAdapter );

void SendNextPacket (
    PNDIS_ADAPTER pAdapter );


void PrintMacAddress (
    PUCHAR bAddr );

NDIS_STATUS GetDeviceMode (
    IN  PNDIS_ADAPTER pAdapter,
    IN  NDIS_OID      Oid,
    IN  PVOID         pBuffer,
    IN  ULONG         ulLen,
    OUT PULONG        pulBytesWritten,
    OUT PULONG        pulBytesNeeded );

NDIS_STATUS SetDeviceMode (
    IN  PNDIS_ADAPTER pAdapter,
    IN  NDIS_OID      Oid,
    IN  PVOID         pBuffer,
    IN  ULONG         ulLen,
    OUT PULONG        pulBytesRead,
    OUT PULONG        pulBytesNeeded );

#ifndef INLINE
PDMA_BUFFER Alloc_DMA_Buffer (
    PBUFFER_INFO pBufInfo,
    PTDesc       pCurrent );

VOID Free_DMA_Buffer (
    PBUFFER_INFO pBufInfo,
    PDMA_BUFFER  pDma );

#else
__inline
PDMA_BUFFER Alloc_DMA_Buffer (
    PBUFFER_INFO pBufInfo,
    PTDesc       pCurrent )
{
    PDMA_BUFFER  pDma;

#ifndef UNDER_CE
    SLIST_ENTRY* pEntry;

    pEntry = NdisInterlockedPopEntrySList( &pBufInfo->listHead,
        &pBufInfo->listLock );
    ASSERT( pEntry != NULL );
    pDma = CONTAINING_RECORD( pEntry, DMA_BUFFER, listEntry );

#else
    ASSERT( pBufInfo->cnAvail );
    pDma = pBufInfo->pTop;
    pBufInfo->pTop = pDma->pNext;
    pBufInfo->cnAvail--;
#endif

    /* Link to current descriptor. */
    pCurrent->pReserved = pDma;
    return( pDma );
}  // Alloc_DMA_Buffer


__inline
VOID Free_DMA_Buffer (
    PBUFFER_INFO pBufInfo,
    PDMA_BUFFER  pDma )
{
#ifndef UNDER_CE
    NdisInterlockedPushEntrySList( &pBufInfo->listHead, &pDma->listEntry,
        &pBufInfo->listLock );

#else
    pDma->pNext = pBufInfo->pTop;
    pBufInfo->pTop = pDma;
    pBufInfo->cnAvail++;
#endif
}
#endif


VOID TransmitDone (
    PNDIS_ADAPTER pAdapter );

VOID TransmitReset (
    PNDIS_ADAPTER pAdapter );

typedef struct {
    UINT cnCount;
    UINT fUsing;
} TDbgHang;

extern TDbgHang hang[];
#endif
