# This is the RPM specification file for the ksz884x driver package.
#
# Use "-bs" option to build source package.
#
# Use "-bb --target=`uname -m`" options to build binary package.
# Add "-D 'target 1' -D 'targetkernel 2.x.y-#.y'" options to build for
# target kernel.
# Add "-D 'nobuild 1'" options to just package the binary.
#
# Use "-i --force" options to install target kernel version.


Summary: KSZ884X Ethernet drivers


%define name ksz884x
%define version 1.0.10
%define release 1


%define builddriver 1

%if 0%{?nobuild}
%define builddriver 0
%endif

%if 0%{?target}
%define kernelvar .%(echo %{targetkernel} | cut -d"." -f4)
%define kernelversion %{targetkernel}
%else
%define kernelversion %(uname -r)
%endif
%define kernelmachine %(uname -m)
%define kernelminor %(uname -r | cut -d"." -f2)

# Check if using 2.6 kernels
%define newerkernel %(if [ "%{kernelminor}" = "6" ]; then echo 1; else echo 0; fi)

%if %{newerkernel}
%define kernelheader /lib/modules/%{kernelversion}/build
%define drivercmd M=$PWD
%define driverext ko
%else
%define kernelheader /usr/src/linux-%{kernelversion}
%define drivercmd SUBDIRS=$PWD
%define driverext o
%endif

# Do not build debuginfo package
%define debug_package %{nil}


Name: %{name}
Version: %{version}
Release: %{release}%{?kernelvar}
Source: %{name}-%{version}.tar.gz

Vendor: Micrel, Inc.
URL: http://www.micrel.com
Packager: Tristram Ha <tristram.ha@micrel.com>
License: GPLv2

Group: System Environment/Kernel

BuildRoot: %{_tmppath}/%{name}-%{version}-root

Prefix: /lib/modules

ExclusiveArch: noarch i386 i486 i586 i686 x86_64 ia64 arm
ExclusiveOS: linux

%if %{builddriver}
BuildPreReq: make
BuildRequires: gcc, binutils
%endif

%if %{newerkernel}
PreReq: module-init-tools
%else
PreReq: modutils
%endif
Provides: kernel-driver


%description
The ksz884x package contains the KSZ884X Ethernet drivers for running in the
Linux system.


%prep

%setup -q

#%patch1 -p1


%build

%if %{builddriver}
%if 0%{?target}
if [ ! -d %{kernelheader} ]; then
    echo "%{kernelheader} does not exist"
    exit 1
fi
%endif

cd LinuxPCI
make clean
if [ -f %{kernelheader}/.config ]; then
CONFIG_KS8841=y make -C %{kernelheader} %{drivercmd} modules
else
CONFIG_KS8841=y make
fi
cp ks8841_pci.%{driverext} ../
make clean
if [ -f %{kernelheader}/.config ]; then
CONFIG_KS8842=y make -C %{kernelheader} %{drivercmd} modules
else
CONFIG_KS8842=y make
fi
cp ks8842_pci.%{driverext} ../
%endif


%clean

rm -rf $RPM_BUILD_ROOT


%install

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/lib/modules/%{kernelversion}/kernel/drivers/net

install -m744 ks8841_pci.%{driverext} $RPM_BUILD_ROOT/lib/modules/%{kernelversion}/kernel/drivers/net/
install -m744 ks8842_pci.%{driverext} $RPM_BUILD_ROOT/lib/modules/%{kernelversion}/kernel/drivers/net/


%files

%defattr(-,root,root)
/lib/modules/%{kernelversion}/kernel/drivers/net/ks8841_pci.%{driverext}
/lib/modules/%{kernelversion}/kernel/drivers/net/ks8842_pci.%{driverext}


%post

/sbin/depmod -q %{kernelversion}


%postun

if [ "$1" = 0 ]; then
/sbin/depmod -q %{kernelversion}
fi
exit 0


%changelog

* Thu Jan 17 2008 Tristram Ha <tristram.ha@micrel.com>
- Created file.
