#!/bin/sh

TG3=tg3-3.117h
KS=ks884x-linux-20090828

prompt()
{
	if test $NONINTERACTIVE; then
		return 0
	fi

	# BASH echo -ne "$*" >&2
	echo -n "$*" >&2
	read CMD rest
	return 0
}

getyn()
{
	if test $NONINTERACTIVE; then
		return 0
	fi

	while prompt "$* (y/n) "
	do	case $CMD in
			[yY])	return 0
				;;
			[nN])	return 1
				;;
			*)	echo -e "\nPlease answer y or n" >&2
				;;
		esac
	done        
}


build_tg3()
{
 	cd $HOME/$TG3
	echo
	eval "make clean"
	eval "make | tee make.out" 
	if [ $? -ne 0 ]; then
    	echo
		echo "Error: Failed to compile Broadcom ($TG3) driver"
		echo "       Contact Sangoma Support: techdesk@sangoma.com"
		echo
		return 1
	fi

    make install
	depmod -a
	echo "Broadcom ($TG3) driver build sucessful!"

	return 0
}


build_micrel()
{
	rel=`uname -r  | cut -d '.' -f3 | cut -d'-' -f1`
    if [ $rel -gt 29 ]; then
        cd $HOME/ks884x-linux-20090828
		KS=ks884x-linux-20090828 
    else
        cd $HOME/ksz884x-1.0.13
		KS=ksz884x-1.0.13 
    fi

	echo
	eval "make clean"
	eval "make | tee make.out" 
	if [ $? -ne 0 ]; then
    	echo
		echo "Error: Failed to compile Micrel (ksz884x-1.0.13) driver"
		echo "       Contact Sangoma Support: techdesk@sangoma.com"
		echo
		return 1
	fi

    make install
	depmod -a
	echo "Micrel ($KS) driver build sucessful!"

	return 0
}

################ MAIN #########################
clear

HOME=`pwd`

while [ 1 ]; 
do
	cmd=$1

	if [ "$cmd" = "" ]; then
        break;
	fi	

  	if [ $cmd = "silent" ]; then
		echo
		echo "Running in interactive mode all optios will be set to yes!"
    	 NONINTERACTIVE=1
	fi

	if [ $cmd = "help" ]; then
    	echo
		echo "Usage: $0 [silent|help]"
		echo
		exit 1
	fi

	shift
done

echo "===================================================="
echo "Checking for exising Broadcom and Micrel Drivers"
echo 
echo "Sangoma: D100 PCIe -> Broadcom Ethernet"
echo "Sangoma: D100 PCI  -> Micrel Ethernet"
echo "===================================================="

echo
rc=1
getyn "Would you like to install Broadcom ($TG3) driver now?"
if [ $? -eq 0 ]; then
   	build_tg3	
    rc=$?
fi

if [ $rc -eq 0 ]; then
	echo
	echo "Broadcom ($TG3) driver installed and loaded!"
	eval "modprobe tg3"
fi

echo "===================================================="
echo
echo

cd $HOME

rc=1
getyn "Would you like to install Micrel (ks8842_pci) driver now?"
if [ $? -eq 0 ]; then
  	build_micrel
    rc=$?
fi

if [ $rc -eq 0 ]; then
	echo
	echo "Micrel (ks8842_pci) driver installed and loaded!"
	eval "modprobe ks8842_pci"
fi    

echo
echo "===================================================="
echo
echo "In order to load the newly installed drivers the kernel"
echo "modules must be reloaded.  You can do so 2 ways:"
echo
echo "1. modprobe -r <module_name>  #unload driver module"
echo "   modprobe <module_name>     #load new driver module"
echo "   Warning: If tg3 or ks8842_pci modules are currently being"
echo "            used by other ethernet devices you will lose"
echo "            access to those devices. Thus make sure you know"
echo "            what you are doing :) "
echo " OR"
echo
echo "2. reboot"
echo
echo

exit 0

