#!/usr/bin/perl -w


# Moises Silva <moy@sangoma.com>
# parse /proc/net/udp in a readable format

sub hextoip {
	
	my $oct1;
	my $oct2;
	my $oct3;
	my $oct4;
	my $ipaddr = $_[0];

	$oct1 = hex(substr($ipaddr, 0, 2));
	$oct2 = hex(substr($ipaddr, 2, 2));
	$oct3 = hex(substr($ipaddr, 4, 2));
	$oct4 = hex(substr($ipaddr, 6, 2));
	$ipaddr = "$oct4.$oct3.$oct2.$oct1";
	return $ipaddr;
}


my $ignore = 1;
my $remoteaddr = "";
my $localaddr = "";
my $ipaddr = "";
my $sl = "";
my $st = "";
my $queues = "";
my $txqueue = "";
my $rxqueue = "";
my $portno = 0;


open (UDPFILE, "/proc/net/udp") || die("failed to open udp proc file\n");

foreach $line (<UDPFILE>) {
	if ($ignore) {
		( $sl, $localaddr, $remoteaddr ) = split(' ', $line);
		$ignore = 0;
		print $localaddr . "\t" . $remoteaddr . "\n";
		next;
	}
	( $sl, $localaddr, $remoteaddr, $st, $queues) = split(' ', $line);

	# not used, lets keeps warnings quite
	$sl = "";
	$st = "";

	# get decimal local addr
	( $ipaddr, $portno ) = split(':', $localaddr);
	$ipaddr = hextoip($ipaddr);
	$localaddr = $ipaddr . ":" . hex($portno);

	# get decimal remote addr
	( $ipaddr, $portno ) = split(':', $remoteaddr);
	$ipaddr = hextoip($ipaddr);
	$remoteaddr = $ipaddr . ":" . hex($portno);

	# set tx and rx queues in decimal too
	( $txqueue, $rxqueue ) = split(':', $queues);
	$txqueue = hex($txqueue);
	$rxqueue = hex($rxqueue);

	$queues = $txqueue . ":" . $rxqueue;

	print $localaddr . "\t" . $remoteaddr . "\t" . $queues . "\n";
}



