# Some commonly used vars for Sangoma builds
SNG_ARCH = $(shell uname -m)

## GNU standard directory variables (kinda) ##
## prefixes are documented at http://www.gnu.org/prep/standards/html_node/Directory-Variables.html#Directory-Variables
## however, most Linux distros are not really complaint with this document, particularly with 2 things:
## 1. 64 bits sometimes use $(prefix)/lib64 directory to store 64 bit libraries
## 2. The /etc/ directory is usually not prefixed with $(prefix)
## we follow those 2 exceptions breaking 100% compliance with the GNU standards
## however users are free to override the defaults

prefix = /usr
exec_prefix = $(prefix)
bindir = $(exec_prefix)/bin
sbindir = $(exec_prefix)/sbin
includedir = $(prefix)/include
lib64_dir = $(exec_prefix)/lib64
libdir = $(exec_prefix)/lib
sysconfdir = /etc

ifeq ($(SNG_ARCH),x86_64)
ifeq ($(wildcard $(lib64_dir)),$(lib64_dir))
libdir = $(lib64_dir)
else
libdir = $(exec_prefix)/lib
endif
else
libdir = $(exec_prefix)/lib
endif

## End GNU directory variables ## 

