/*
 * libsngtc-node
 * Sangoma Transcoder Node Library
 *
 * Copyright (C) 2010 Sangoma Technologies
 * Nenad Corbic <ncorbic@sangoma.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *
 * Moises Silva <moy@sangoma.com>
 *
 */

#include "soapH.h"
#include "sngtc_node.h"
#include "sngtc_node_utils.h"

iana_to_profile_t iana_profile_map[] =
{
	{ 1, SNGTC_CODEC_PCMU,    	IANA_PCMU_A_8000_1},	   /*0:   ms= 10,20,30,40 */
	{ 1, SNGTC_CODEC_PCMA,    	IANA_PCMA_A_8000_1},	   /*8:   ms= 10,20,30,40 */
	{ 1, SNGTC_CODEC_L16_1,   	IANA_L16_A_8000_1},   /*106: ms= 10,20,30,40 */
	{ 1, SNGTC_CODEC_L16_2,   	IANA_L16_A_8000_2},   /*106: ms= 10,20,30,40 */

	{ 1, SNGTC_CODEC_G729AB,   IANA_G729_A_8000_1},  /*18:  ms= 10,20,30,40 */
	{ 1, SNGTC_CODEC_G722,    	IANA_G722_A_8000_1},  /*9:   ms= 10,20 */
	{ 1, SNGTC_CODEC_G726_32, 	IANA_G726_32_8000_1},  /*100: ms= 10,20,30,40 */
	{ 1, SNGTC_CODEC_AMR,     	IANA_AMR_A_8000_1 },  /*97:  ms= 20,40 */

	{ 1, SNGTC_CODEC_GSM_FR,  	IANA_GSM_A_8000_1 },  /*3    ms= 20 */
	{ 1, SNGTC_CODEC_GSM_EFR, 	IANA_EFR_A_8000_1 },  /*102: ms= 20 */
	{ 1, SNGTC_CODEC_ILBC_133,  	IANA_ILBC_133_8000_1 },   /*105: ms= 20,40 */
	{ 1, SNGTC_CODEC_ILBC_152,  	IANA_ILBC_152_8000_1 },   /*105: ms= 20,40 */

	{ 0, 0, 0  },
};

int sngtc_verify_init_cfg(sngtc_init_cfg_t *cfg)
{

	if (cfg->create_rtp == NULL) {
		SNGTC_ERROR("%s:%d: SNGTC: Error invalid create_rtp func pointer NULL\n",
					__FUNCTION__,__LINE__);
		return -1;
	}
	if (cfg->create_rtp_port == NULL) {
		SNGTC_ERROR("%s:%d: SNGTC: Error invalid create_rtp_port func pointer NULL\n",
					__FUNCTION__,__LINE__);
		return -1;
	}
	if (cfg->destroy_rtp == NULL) {
		SNGTC_ERROR("%s:%d: SNGTC: Error invalid destroy_rtp func pointer NULL\n",
					__FUNCTION__,__LINE__);
		return -1;
	}

	return 0;
}

int sngtc_set_iana_code_based_on_codec_id(uint32_t codec_id, uint32_t iana)
{
	int i;

	for (i=0;i<MAX_CODEC_ID_SZ;i++) {

		if (codec_id == iana_profile_map[i].codec_id) {
			if (iana_profile_map[i].init) {
				iana_profile_map[i].iana_code = iana;
				return 0;
			}
		}

		if (iana_profile_map[i].init == 0) {
			break;
		}
	}

	return -1;
}       

